#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timer 4 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  OpenTimer4                                     *
*    Description:    This routine configures the timer control regis*
*                    ter and timer period register.                 *
*    Parameters:     config: bit definitions to configure Timer4    *
*                    period: value to be loaded to PR reg           *
*    Return Value:   None                                           *
********************************************************************/

void OpenTimer4(unsigned int config,unsigned int period)
{
    TMR4  = 0;          /* Reset Timer4 to 0x0000 */
    PR4   = period;     /* assigning Period to Timer period register */
    T4CON = config;     /* configure timer control reg */
    T4CONbits.T32 = 0;
}

#endif 
